/*****************************************************************************
 *  Module for Microchip Graphics Library
 *  Ilitek RA8872 LCD controller driver
 *****************************************************************************
 * FileName:        ILI9163.c
 * Processor:       PIC32
 * Compiler:        MPLAB C32
 * Company:         Displaytech Ltd.
 *
 * Date        	Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * 06/22/12     Initial Revision
  ***************************************************************************/

#ifndef _RA8872_H
#define _RA8872_H

#include "HardwareProfile.h"
#include "GenericTypeDefs.h"

#ifdef USE_PALETTE
#include "Graphics/Palette.h"
#endif

/*********************************************************************
 * Error Checking
 *********************************************************************/
#ifndef DISP_HOR_RESOLUTION
#error DISP_HOR_RESOLUTION must be defined in HardwareProfile.h
#endif
#ifndef DISP_VER_RESOLUTION
#error DISP_VER_RESOLUTION must be defined in HardwareProfile.h
#endif
#ifndef DISP_ORIENTATION
#error DISP_ORIENTATION must be defined in HardwareProfile.h
#endif

/*********************************************************************
 * Overview: RA8872 registers definitions.
 *********************************************************************/

//Command List
#define PCOD					0x00 	//Product Code Register
#define PWRR					0x01 	//Power and Display Controller Register
#define MRWC					0x02 	//Memory Read/Write Command
#define PCLK					0x04	//Pixel Clock Register
#define SYSR					0x10	//System Configuration Register
#define DRGB					0x11	//Panel Data Type Register
#define IOCR					0x12	//GPIO Configure Register
#define IODR					0x13	//GPIO Data Register
#define HDWR					0x14	//LCD Horizontal Display Width Register
#define HNDFTR					0x15	//Horizontal Non-Display Period Fine Tuning Option Register
#define HNDR					0x16	//LCD Horizontal Non-Display Period Register
#define HSTR					0x17	//HSYNC Start Position Register
#define HPWR					0x18	//HSYNC PWM Register
#define VDHR0					0x19	//LCD Vertical Display Height Register
#define VDHR1					0x1A	//LCD Vertical Display Height Register
#define VNDR0					0x1B	//LCD Vertical Non-Display Period Register
#define VNDR1					0x1C	//LCD Vertical Non-Display Period Register
#define VSTR0					0x1D	//VSYNC Start Position Register
#define VSTR1					0x1E	//VSYNC Start Position Register
#define VPWR					0x1F	//VSYNC PWM Register
#define DPCR					0x20	//Display Configuration Register
#define FNCR0					0x21	//Font Control Register 0
#define FNCR1					0x22	//Font Control Register 1
#define CGSR					0x23	//CGRAM Select Register
#define HOFS0					0x24	//Horizontal Scroll Offset Register
#define HOFS1					0x25	//Horizontal Scroll Offset Register
#define VOFS0					0x26	//Vertical Scroll Offset Register
#define VOFS1					0x27	//Vertical Scroll Offset Register
#define FLDR					0x29	//Font Line Distance Setting Register
#define HSAW0					0x30	//Horizontal Start Point of Active Window.
#define HSAW1					0x31	//Horizontal Start Point of Active Window.
#define VSAW0					0x32	//Vertical Start Point of Active Window.
#define VSAW1					0x33	//Vertical Start Point of Active Window.
#define HEAW0					0x34	//Horizontal End Point of Active Window. 
#define HEAW1					0x35	//Horizontal End Point of Active Window. 
#define VEAW0					0x36	//Vertical End Point of Active Window.
#define VEAW1					0x37	//Vertical End Point of Active Window.
#define HSSW0					0x38	//Horizontal Start Point of Scroll Window. 
#define HSSW1					0x39	//Horizontal Start Point of Scroll Window. 
#define VSSW0					0x3A	//Vertical Start Point of Scroll Window.
#define VSSW1					0x3B	//Vertical Start Point of Scroll Window.
#define HESW0					0x3C	//Horizontal End Point of Scroll Window.
#define HESW1					0x3D	//Horizontal End Point of Scroll Window.
#define VESW0					0x3E	//Vertical End Point of Scroll Window.
#define VESW1					0x3F	//Vertical End Point of Scroll Window.
#define MWCR0					0x40	//Memory Write Control Register 0
#define MWCR1					0x41	//Memory Write Control Register 1
#define TFCR					0x42	//Text Foreground Color Register.
#define TBCR					0x43	//Text Background Color Register.
#define BTCR					0x44	//Blink Time Control Register
#define CURS					0x45	//Text Cursor Size Register
#define CURH0					0x46	//Memory Write Cursor Horizontal Position Register
#define CURH1					0x47	//Memory Write Cursor Horizontal Position Register
#define CURV0					0x48	//Memory Write Cursor Vertical Position Register
#define CURV1					0x49	//Memory Write Cursor Vertical Position Register
#define RCURH0					0x4A	//Memory Read Cursor Horizontal Position Register
#define RCURH01					0x4B	//Memory Read Cursor Horizontal Position Register
#define RCURV0					0x4C	//Memory Read Cursor Vertical Position Register
#define RCURV1					0x4D	//Memory Read Cursor Vertical Position Register
#define MCRD					0x4E	//Memory Read Cursor Direction
#define BECR0					0x50	//BTE Function Control Register 0.
#define BECR1					0x51	//BTE Function Control Register 1.
#define LPTR0					0x52	//Layer Transparency Register 0.
#define LPTR1					0x53	//Layer Transparency Register 1.
#define HSBE0					0x54	//Horizontal Source Point of BTE.
#define HSBE1					0x55	//Horizontal Source Point of BTE.
#define VSBE0					0x56	//Vertical Source Point of BTE.
#define VSBE1					0x57	//Vertical Source Point of BTE.
#define HDBE0					0x58	//Horizontal Destination Point of BTE.
#define HDBE1					0x59	//Horizontal Destination Point of BTE.
#define VDBE0					0x5A	//Vertical Destination Point of BTE
#define VDBE1					0x5B	//Vertical Destination Point of BTE
#define BEWR0					0x5C	//BTE Width Register
#define BEWR1					0x5D	//BTE Width Register
#define BEHR0					0x5E	//BTE Height Register
#define BEHR1					0x5F	//BTE Height Register
#define BGCR0					0x60	//BTE Background Color Register  RED.
#define BGCR1					0x61	//BTE Background Color Register  GREEN.
#define BGCR2					0x62	//BTE Background Color Register  BLUE.
#define FGCR0					0x63	//BTE Foreground Color Register  RED.
#define FGCR1					0x64	//BTE Foreground Color Register  GREEN.
#define FGCR2					0x65	//BTE Foreground Color Register  BLUE.
#define PNTO					0x66	//Pattern Set Number for BTE.
#define BGTR					0x67	//Background Color Register for Transparent.
#define TPCR0					0x70	//Touch Panel Control Register 0.
#define TPCR1					0x71	//Touch Panel Control Register 1.
#define TPXH					0x72	//Touch Panel X High Byte Data Register.
#define TPYH					0x73	//Touch Panel Y High Byte Data Register.
#define TPXYL					0x74	//Touch Panel Segment / Common Low Byte Data Register
#define GCHP0					0x80	//Graphic Cursor Horizontal Position Register.
#define GCHP1					0x81	//Graphic Cursor Horizontal Position Register.
#define GCVP0					0x82	//Graphic Cursor Vertical Position Register.
#define GCVP1					0x83	//Graphic Cursor Vertical Position Register.
#define GCC0					0x84	//Graphic Cursor Color Selection  0.
#define GCC1					0x85	//Graphic Cursor Color Selection  1.
#define PLLC0					0x88	//PLL Control Register 0.
#define PLLC1					0x89	//PLL Control Register 1.
#define P1CR					0x8A	//PWM1 Control Register.
#define P1DCR					0x8B	//PWM1 Duty Cycle Register.
#define P2CR					0x8C	//PWM2 Control Register.
#define P2DCR					0x8D	//PWM2 Control Register.
#define MCLR					0x8E	//Memory Clear Control Register.
#define INTC					0x8F	//Interrupt Control Register.
#define DCR                                     0x90	//Draw Line/Circle / Square Control Register.
#define DLHSR0					0x91	//Draw Line / Square Horizontal Start Address Register.
#define DLHSR1					0x92	//Draw Line / Square Horizontal Start Address Register.
#define DLVSR0					0x93	//Draw Line / Square Vertical Start Address Register.
#define DLVSR1					0x94	//Draw Line / Square Vertical Start Address Register.
#define DLHER0					0x95	//Draw Line / Square Horizontal End Address Register.
#define DLHER1					0x96	//Draw Line / Square Horizontal End Address Register.
#define DLVER0					0x97	//Draw Line / Square Vertical End Address Register.
#define DLVER1					0x98	//Draw Line / Square Vertical End Address Register.
#define DCHR0					0x99	//Draw Circle Center Horizontal Address Register.
#define DCHR1					0x9A	//Draw Circle Center Horizontal Address Register.
#define DCVR0					0x9B	//Draw Circle Center Vertical Address Register.
#define DCVR1					0x9C	//Draw Circle Center Vertical Address Register.
#define DCRR					0x9D	//Draw Circle Radius Register.


//Masks for orientation and memory write/read directions
#define VDIR_MASK      0x04
#define HDIR_MASK      0x08
#define ROT_90_MASK    0x01
#define ROT_180_MASK   0x02
#define ROT_270_MASK   0x03

inline void ScrollWindow(WORD XL, WORD XR, WORD YT, WORD YB);
inline void VerticalScroll(WORD offset);
inline void HorizontalScroll(WORD offset);
#endif // _RA8872_H
