/*****************************************************************************
 *
 * This document contains proprietary information and except with
 * written permission of Displaytech, Ltd., such information shall
 * not be published or disclosed to others or used for any purpose
 * other than for the operation and maintenance of the equipment
 * and software with which it was procured, and the document shall
 * not be copied in whole or in part.
 *
 * Copyright 2008-2015 Displaytech, Ltd. All Rights Reserved.
 *
 *****************************************************************************
 *  Module for Microchip Graphics Library
 *  Solomon Systech. ILI9341 LCD controllers driver
 *****************************************************************************
 * FileName:        ILI9341.h
 * Processor:       PIC24, PIC32
 * Compiler:        MPLAB C30, MPLAB C32
 * Company:         Displaytech Ltd
 *
 * Date            Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * 06/22/12     Initial Revision
 *****************************************************************************/

#ifndef _ILI9341_H
    #define _ILI9341_H

    #include "HardwareProfile.h"
    #include "GenericTypeDefs.h"

    #ifdef USE_PALETTE
        #include "Graphics/Palette.h"
    #endif

/*********************************************************************
* Error Checking
*********************************************************************/
    #ifndef DISP_HOR_RESOLUTION
        #error DISP_HOR_RESOLUTION must be defined in HardwareProfile.h
    #endif
    #ifndef DISP_VER_RESOLUTION
        #error DISP_VER_RESOLUTION must be defined in HardwareProfile.h
    #endif
    #ifndef DISP_ORIENTATION
        #error DISP_ORIENTATION must be defined in HardwareProfile.h
    #endif

/*********************************************************************
* PARAMETERS VALIDATION
*********************************************************************/
    #if COLOR_DEPTH != 16
        #error This driver supports 16 BPP only.
    #endif
    #if (DISP_HOR_RESOLUTION % 8) != 0
        #error Horizontal resolution must be divisible by 8.
    #endif
    #if (DISP_ORIENTATION != 0) && (DISP_ORIENTATION != 180) && (DISP_ORIENTATION != 90) && (DISP_ORIENTATION != 270)
        #error The display orientation selected is not supported. It can be only 0,90,180 or 270.
    #endif

/*********************************************************************
* Overview: ILI9341 registers definitions.
*********************************************************************/

    //Command List
    #define NOP                        0x00
    #define SOFTWARE_RESET            0x01
    #define READ_ID                    0x04
    #define READ_STATUS                0x09
    #define READ_POWER_MODE            0x0A
    #define READ_MADCTL                0x0B
    #define READ_PIXEL_FORMAT        0x0C
    #define READ_IMAGE_FORMAT        0x0D
    #define READ_SIGNAL_MODE        0x0E
    #define READ_DIAGNOSTIC            0x0F
    #define ENTER_SLEEP_MODE        0x10
    #define SLEEP_OUT                0x11
    #define    PARTIAL_MODE_ON            0x12
    #define NORMAL_MODE_ON            0x13
    #define INVERSION_OFF            0x20
    #define INVERSION_ON            0x21
    #define GAMMA_SET                0x26
    #define DISPLAY_OFF                0x28
    #define DISPLAY_ON                0x29
    #define COLUMN_ADDRESS_SET        0x2A
    #define PAGE_ADDRESS_SET        0x2B
    #define MEMORY_WRITE            0x2C
    #define COLOR_SET                0x2D
    #define MEMORY_READ                0x2E
    #define PARTIAL_AREA            0x30
    #define VERTSCROLL_DEF            0x33
    #define TEARING_LINE_OFF        0x34
    #define TEARING_LINE_ON            0x35
    #define MEMORY_ACCESS_CTRL        0x36
    #define VERTSCROLL_START_ADDR    0x37
    #define IDLE_MODE_OFF            0x38
    #define IDLE_MODE_ON            0x39
    #define PIXEL_FORMAT_SET        0x3A
    #define WRITE_MEMORY_CONTINUE    0x3C
    #define READ_MEMORY_CONTINUE    0x3E
    #define SET_TEAR_SCANLINE        0x44
    #define GET_SCANLINE            0x45
    #define WRITE_DISPLAY_BRIGHT    0x51
    #define READ_DISPLAY_BRIGHT        0x52
    #define WRITE_CTRL_DISPLAY        0x53
    #define READ_CTRL_DISPLAY        0x54
    #define WRITE_CONTADAPT_BRIGHT    0x55
    #define READ_CONTADAPT_BRIGHT    0x56
    #define WRITE_CABC_MIN_BRIGHT    0x5E
    #define READ_CABC_MIN_BRIGHT    0x5F
    #define READ_ID1                0xDA
    #define READ_ID2                0xDB
    #define READ_ID3                0xDC
    #define RGB_INTERFACE_SIGNAL    0xB0
    #define FRAME_RATE_NORMAL        0xB1
    #define FRAME_RATE_IDLE            0xB2
    #define FRAME_RATE_PARTIAL        0xB3
    #define DISPLAY_INVERSION        0xB4
    #define BLANKING_PORCH            0xB5
    #define DISPLAY_FUNCTION        0xB6
    #define ENTRY_MODE_SET            0xB7
    #define BACKLIGHT_1                0xB8
    #define BACKLIGHT_2                0xB9
    #define BACKLIGHT_3                0xBA
    #define BACKLIGHT_4                0xBB
    #define BACKLIGHT_5                0xBC
    #define BACKLIGHT_6                0xBD
    #define BACKLIGHT_7                0xBE
    #define BACKLIGHT_8                0xBF
    #define POWER_1                    0xC0
    #define POWER_2                    0xC1
    #define VCOM_1                    0xC5
        #define VCOM_2                    0xC7
        #define POWER_A                                 0xCB
        #define POWER_B                                 0xCF
    #define NV_MEMORY_WRITE            0xD0
    #define NV_MEMORY_PROTECT_KEY    0xD1
    #define NV_MEMORY_STATUS_READ    0xD2
    #define READ_ID4                0xD3
    #define POSITIVE_GAMMA_CORRECT    0xE0
    #define NEGATIVE_GAMMA_CORRECT    0xE1
    #define DIGITAL_GAMMA_CONTROL_1    0xE2
    #define DIGITAL_GAMMA_CONTROL_2    0xE3
    #define INTERFACE_CONTROL        0xF6
    #define POWER_CONTROL_A            0xCB
    #define POWER_CONTROL_B            0xCF
    #define DRIVER_TIMING_CONTROL_A    0xE8
    #define DRIVER_TIMING_CONTROL_B    0xEA
    #define POWER_ON_SEQUENCE_CTRL    0xED
    #define ENABLE_3_GAMMA            0xF2
    #define PUMP_RATIO_CONTROL        0xF7

#endif // _ILI9341_H
