/*****************************************************************************
 *
 * This document contains proprietary information and except with
 * written permission of Displaytech, Ltd., such information shall
 * not be published or disclosed to others or used for any purpose
 * other than for the operation and maintenance of the equipment
 * and software with which it was procured, and the document shall
 * not be copied in whole or in part.
 *
 * Copyright 2008-2015 Displaytech, Ltd. All Rights Reserved.
 *
 *****************************************************************************
 *  Module for Microchip Graphics Library
 *  Ilitek ILI9163
 *****************************************************************************
 * FileName:        ILI9163.h
 * Processor:       PIC24F, PIC24H, dsPIC, PIC32
 * Compiler:        MPLAB C30, MPLAB C32
 * Company:         Displaytech Ltd.
 *
 * Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * 06/30/2012  Initial Revision
 *****************************************************************************/

#ifndef _ILI9163_H
    #define _ILI9163_H

    #ifdef __PIC32MX
        #include <plib.h>
        #define PMDIN1  PMDIN
    #else
        #ifdef __PIC24F__
            #include <p24Fxxxx.h>
        #else
            #error CONTROLLER IS NOT SUPPORTED
        #endif
    #endif
    #include "GraphicsConfig.h"
    #include "GenericTypeDefs.h"

/*********************************************************************
* Overview: Additional hardware-accelerated functions can be implemented
*           in the driver. These definitions exclude the PutPixel()-based
*           functions in the primitives layer (Primitive.c file) from compilation.
*********************************************************************/

    #ifndef DISP_HOR_RESOLUTION
        #error DISP_HOR_RESOLUTION must be defined in GraphicsConfig.h
    #endif
    #ifndef DISP_VER_RESOLUTION
        #error DISP_VER_RESOLUTION must be defined in GraphicsConfig.h
    #endif
    #ifndef COLOR_DEPTH
        #error COLOR_DEPTH must be defined in GraphicsConfig.h
    #endif
    #ifndef DISP_ORIENTATION
        #error DISP_ORIENTATION must be defined in GraphicsConfig.h
    #endif

/*********************************************************************
* Overview: Driver Register Definitions
*********************************************************************/

    #define NOP                        0x00
    #define SOFTWARE_RESET            0x01
    #define READ_ID                    0x04
    #define READ_STATUS                0x09
    #define READ_POWER_MODE            0x0A
    #define READ_MADCTL                0x0B
    #define READ_PIXEL_FORMAT        0x0C
    #define READ_IMAGE_MODE            0x0D
    #define READ_SIGNAL_MODE        0x0E
    #define READ_DIAGNOSTIC            0x0F
    #define SLEEP_IN                0x10
    #define SLEEP_OUT                0x11
    #define    PARTIAL_MODE_ON            0x12
    #define NORMAL_MODE_ON            0x13
    #define INVERSION_OFF            0x20
    #define INVERSION_ON            0x21
    #define GAMMA_SET                0x26
    #define DISPLAY_OFF                0x28
    #define DISPLAY_ON                0x29
    #define COLUMN_ADDRESS_SET        0x2A
    #define PAGE_ADDRESS_SET        0x2B
    #define MEMORY_WRITE            0x2C
    #define COLOR_SET                0x2D
    #define MEMORY_READ                0x2E
    #define PARTIAL_AREA            0x30
    #define VERTSCROLL_DEF            0x33
    #define TEARING_LINE_OFF        0x34
    #define TEARING_LINE_ON            0x35
    #define MEMORY_ACCESS_CTRL        0x36
    #define VERTSCROLL_START_ADDR    0x37
    #define IDLE_MODE_OFF            0x38
    #define IDLE_MODE_ON            0x39
    #define PIXEL_FORMAT_SET        0x3A
    #define READ_ID1                0xDA
    #define READ_ID2                0xDB
    #define READ_ID3                0xDC
    #define FRAME_RATE_NORMAL        0xB1
    #define FRAME_RATE_IDLE            0xB2
    #define FRAME_RATE_PARTIAL        0xB3
    #define DISPLAY_INVERSION        0xB4
    #define SOURCE_DRIVER_DIR        0xB7
    #define GATE_DRIVER_DIR            0xB8
    #define POWER_1                    0xC0
    #define POWER_2                    0xC1
    #define POWER_3                    0xC2
    #define POWER_4                    0xC3
    #define POWER_5                    0xC4
    #define VCOM_1                    0xC5
    #define VCOM_2                    0xC6
    #define VCOM_OFFSET                0xC7
    #define WRITE_ID4                0xD3
    #define NV_MEMORY_FUNCTION        0xD7
    #define NV_MEMORY_FUNCTION2        0xDE
    #define POSITIVE_GAMMA_CORRECT    0xE0
    #define NEGATIVE_GAMMA_CORRECT    0xE1
    #define GAM_R_SEL                0xF2

#endif // _ILI9163
