/*****************************************************************************
 *
 * This document contains proprietary information and except with
 * written permission of Displaytech, Ltd., such information shall
 * not be published or disclosed to others or used for any purpose
 * other than for the operation and maintenance of the equipment
 * and software with which it was procured, and the document shall
 * not be copied in whole or in part.
 *
 * Copyright 2008-2014 Displaytech, Ltd. All Rights Reserved.
 *
 *****************************************************************************/

#include "GenericTypeDefs.h"


typedef union {
    UINT32 u32;

    struct{
        UINT16    y : 12;
        UINT8    id : 4;
        UINT16    x : 12;
        UINT8       : 2;
        UINT8 event : 2;
    };

}touch_packet_t;

#define GEST_NONE       0x00
#define GEST_UP         0x10
#define GEST_LEFT       0x14
#define GEST_DOWN       0x18
#define GEST_RIGHT      0x1C
#define GEST_IN         0x48
#define GEST_OUT        0x49

void TouchHardwareInit(void);
void TouchGetPosition(void);
SHORT TouchGetX(void);
SHORT TouchGetY(void);

#define I2C_SLAVE_ADDRESS 0x70
#define I2C_WRITE_BYTE (0x70)
#define I2C_READ_BYTE  (0x71)
#define MAX_TOUCHES 5
